<?php

namespace CocktailRecipes\Recipes\Values\Units;

/**
 * Teaspoons
 *
 * 1 tsp = 1/3 tbsp = 2/3 parts
 */
class Teaspoon extends Part
{
    protected const MIN_AMOUNT = 0.25;  // 1/4 tsp
    protected const MAX_AMOUNT = 12;    // 12 tsp (2 oz)
    protected const RANGE_WIDTH_FLOOR = 0.25;

    // Conversion constants
    protected const TSP_PER_PART = 1.5;
    protected const PRECISION = 0.25;       // round to nearest 1/4 tsp

    protected function init(array $options): void
    {
        $this->symbol = _x('tsp', 'measurement (symbol)', 'cocktail-recipes');
    }

    public function name($count = 1): string
    {
        return _nx('teaspoon', 'teaspoons', $count, 'measurement', 'cocktail-recipes');
    }

    protected function toParts(float $value): float
    {
        return $value / self::TSP_PER_PART;
    }

    protected function fromParts(float $value): float
    {
        return $value * self::TSP_PER_PART;
    }

    public static function identifiers(): string
    {
        return __("tsp.,t.,ts.,tspn.,teaspoon,teaspoons", 'cocktail-recipes');
    }

    public static function upperSymbols(): string
    {
        return _x("-", 'uppercase teaspoon symbols; "-" if none', 'cocktail-recipes');
    }
}
