<?php

namespace CocktailRecipes\Recipes\Values\Units;

/**
 * Tablespoons
 *
 * 1 tbsp = 1/2 oz = 2 parts
 */
class Tablespoon extends Part
{
    protected const MIN_AMOUNT = 0.25;  // 1/4 tbsp
    protected const MAX_AMOUNT = 8;     // 8 tbsp (4 oz)
    protected const RANGE_WIDTH_FLOOR = 0.25;

    // Conversion constants
    protected const PARTS_PER_TBSP = 2.0;
    protected const PRECISION = 0.25;       // round to nearest 1/4 tbsp
    protected const SMALL_PARTS_AS = [
        [1, 'Teaspoon'],                // under 1 part (1/2 tbsp): tsp
        [2, 'Tablespoon', 'Teaspoon'],  // under 2 parts (1 tbsp): tbsp or tsb (best fit)
    ];

    protected function init(array $options): void
    {
        $this->symbol = _x('tbsp', 'measurement (symbol)', 'cocktail-recipes');
    }

    public function name($count = 1): string
    {
        return _nx('tablespoon', 'tablespoons', $count, 'measurement', 'cocktail-recipes');
    }

    protected function toParts(float $value): float
    {
        return $value * self::PARTS_PER_TBSP;
    }

    protected function fromParts(float $value): float
    {
        return $value / self::PARTS_PER_TBSP;
    }

    public static function identifiers(): string
    {
        return __("tbsp.,tb.,tbl.,tbs.,tbls.,tblsp.,tablespoon,tablespoons", 'cocktail-recipes');
    }

    public static function upperSymbols(): string
    {
        return _x("T.", 'uppercase tablespoon symbols', 'cocktail-recipes');
    }
}
