<?php

namespace CocktailRecipes\Recipes\Values\Units;

use CocktailRecipes\Recipes\Features\RequiresWholeUnits;

class Splash extends Unit
{
    use RequiresWholeUnits;

    protected const MIN_AMOUNT = 1;
    protected const MAX_AMOUNT = 4;
    protected const RANGE_WIDTH_FLOOR = 1;

    public function name($count = 1): string
    {
        return _nx('splash', 'splashes', $count, 'measurement', 'cocktail-recipes');
    }

    public static function identifiers(): string
    {
        return __("splash,splashes", 'cocktail-recipes');
    }

    public static function upperSymbols(): string
    {
        return _x("-", 'uppercase splash symbols; "-" if none', 'cocktail-recipes');
    }
}
