<?php

namespace CocktailRecipes\Recipes\Values\Units;

/**
 * Ounces
 *
 * 1 oz = 4 parts
 */
class Ounce extends Part
{
    protected const MIN_AMOUNT = 0.25;  // 1/4 oz
    protected const MAX_AMOUNT = 8;     // 8 oz
    protected const RANGE_WIDTH_FLOOR = 0.25;

    // Conversion constants
    protected const PARTS_PER_OZ = 4.0;
    protected const PRECISION = 0.25;   // round to nearest 1/4 oz
    protected const SMALL_PARTS_AS = [
        [1, 'Teaspoon'],            // under 1 part (1/4 oz): tsp
        [2, 'Ounce', 'Teaspoon'],   // under 2 parts (1/2 oz): oz or tsp (best fit)
    ];

    protected function init(array $options): void
    {
        $this->symbol = _x('oz', 'measurement (symbol)', 'cocktail-recipes');
    }

    public function name($count = 1): string
    {
        return _nx('ounce', 'ounces', $count, 'measurement', 'cocktail-recipes');
    }

    protected function toParts(float $value): float
    {
        return $value * self::PARTS_PER_OZ;
    }

    protected function fromParts(float $value): float
    {
        return $value / self::PARTS_PER_OZ;
    }

    public static function identifiers(): string
    {
        // U+2125 = Ounce Sign
        return __("oz.,fl oz,fl. oz.,\u{2125},ounce,ounces,fluid ounce,fluid ounces", 'cocktail-recipes');
    }

    public static function upperSymbols(): string
    {
        return _x("-", 'uppercase ounce symbols; "-" if none', 'cocktail-recipes');
    }
}
