<?php

namespace CocktailRecipes\Recipes\Values\Units;

use CocktailRecipes\Recipes\Features\RequiresWholeUnits;

/**
 * Drop
 *
 * About 1/60 tsp or 0.08 mL
 */
class Drop extends Unit
{
    use RequiresWholeUnits;

    protected const MIN_AMOUNT = 1;
    protected const MAX_AMOUNT = 8;
    protected const RANGE_WIDTH_RATIO = 3.0;
    protected const RANGE_WIDTH_FLOOR = 1;

    public function name($count = 1): string
    {
        return _nx('drop', 'drops', $count, 'measurement', 'cocktail-recipes');
    }

    public static function identifiers(): string
    {
        return __("drop,drops", 'cocktail-recipes');
    }

    public static function upperSymbols(): string
    {
        return _x("-", 'uppercase drop symbols; "-" if none', 'cocktail-recipes');
    }
}
