<?php

namespace CocktailRecipes\Recipes\Values\Units;

use CocktailRecipes\Recipes\Features\RequiresWholeUnits;

/**
 * Dash
 *
 * About 1/5 teaspoon or 1 mL
 */
class Dash extends Unit
{
    use RequiresWholeUnits;

    protected const MIN_AMOUNT = 1;
    protected const MAX_AMOUNT = 8;
    protected const RANGE_WIDTH_RATIO = 3.0;
    protected const RANGE_WIDTH_FLOOR = 1;

    public function name($count = 1): string
    {
        return _nx('dash', 'dashes', $count, 'measurement', 'cocktail-recipes');
    }

    public static function identifiers(): string
    {
        return __("dash,dashes", 'cocktail-recipes');
    }

    public static function upperSymbols(): string
    {
        return _x("-", 'uppercase dash symbols; "-" if none', 'cocktail-recipes');
    }
}
