<?php

namespace CocktailRecipes\Recipes\Values\Units;

use CocktailRecipes\Recipes\Features\ShowDecimalUnits;

/**
 * Cubic Centimeters
 *
 * Same volume as mL
 */
class CubicCentimeter extends Part
{
    use ShowDecimalUnits;

    protected const MIN_AMOUNT = 1;     // 1 cc (~1/4 tsp)
    protected const MAX_AMOUNT = 240;   // 240 cc (~8 oz)
    protected const RANGE_WIDTH_FLOOR = 1;

    // Conversion constants
    protected const CC_PER_PART = 7.5;
    protected const PRECISION = 7.5;    // round to nearest 7.5 cc
    protected const SMALL_PARTS_AS = [
        [5 / 7.5, 0.25],        // under 5 cc: use 0.25 cc precision
        [10 / 7.5, 2.5],        // under 10 cc: use 2.5 cc precision
    ];


    protected function init(array $options): void
    {
        $this->symbol = _x('cc', 'measurement (symbol)', 'cocktail-recipes');
    }

    public function name($count = 1): string
    {
        return _nx('cubic centimeter', 'cubic centimeters', $count, 'measurement', 'cocktail-recipes');
    }

    protected function toParts(float $value): float
    {
        return $value / self::CC_PER_PART;
    }

    protected function fromParts(float $value): float
    {
        return $value * self::CC_PER_PART;
    }

    public static function identifiers(): string
    {
        // U+33A4 = Square cm Cubed
        // U+00B3 = Superscript 3
        return __("cc.,c.c,c.c.,\u{33A4},cm\u{00B3},cubic centimeter,cubic centimeters,cubic centimetre,cubic centimetres", 'cocktail-recipes');
    }

    public static function upperSymbols(): string
    {
        return _x("-", 'uppercase cubic centimeter symbols; "-" if none', 'cocktail-recipes');
    }
}
