<?php

namespace CocktailRecipes\Recipes\Values\Units;

use CocktailRecipes\Recipes\Features\ShowDecimalUnits;

/**
 * Centiliters
 *
 * 1 cL = 10 mL
 */
class Centiliter extends Part
{
    use ShowDecimalUnits;

    protected const MIN_AMOUNT = 0.1;   // 0.1 cL (~1/4 tsp)
    protected const MAX_AMOUNT = 24;    // 24 cL (~8 oz)
    protected const RANGE_WIDTH_FLOOR = 0.1;

    // Conversion constants
    protected const CL_PER_PART = 0.75;
    protected const PRECISION = 0.75;   // round to nearest 0.75 cL
    protected const SMALL_PARTS_AS = [
        [0.5 / 0.75, 0.25, 'Milliliter'],  // under 0.5 cL: use mL with 0.25 precision
        [1 / 0.75, 2.5, 'Milliliter'],     // under 1 cL: use mL with 2.5 precision
    ];

    protected function init(array $options): void
    {
        $this->symbol = _x('cL', 'measurement (symbol)', 'cocktail-recipes');
    }

    public function name($count = 1): string
    {
        return _nx('centiliter', 'centiliters', $count, 'measurement', 'cocktail-recipes');
    }

    protected function toParts(float $value): float
    {
        return $value / self::CL_PER_PART;
    }

    protected function fromParts(float $value): float
    {
        return $value * self::CL_PER_PART;
    }

    public static function identifiers(): string
    {
        // U+2113 = Script Small L
        return __("cl.,c.l,c.l.,c\u{2113}.,centiliter,centiliters,centilitre,centilitres", 'cocktail-recipes');
    }

    public static function upperSymbols(): string
    {
        return _x("-", 'uppercase centiliter symbols; "-" if none', 'cocktail-recipes');
    }
}
