<?php

namespace CocktailRecipes\Recipes\Values\Units;

use CocktailRecipes\Recipes\Features\RequiresWholeUnits;

/**
 * Bar Spoon
 *
 * In US, typically the same size as a teaspoon (~5ml)
 * In Europe and Japan, typically about half (~2.5ml)
 */
class BarSpoon extends Unit
{
    use RequiresWholeUnits;

    protected const MIN_AMOUNT = 1;
    protected const MAX_AMOUNT = 8;
    protected const RANGE_WIDTH_FLOOR = 1;

    public function name($count = 1): string
    {
        return _nx('bar spoon', 'bar spoons', $count, 'measurement', 'cocktail-recipes');
    }

    public static function identifiers(): string
    {
        return __("barspoon,barspoons,bar spoon,bar spoons", 'cocktail-recipes');
    }

    public static function upperSymbols(): string
    {
        return _x("-", 'uppercase bar spoon symbols; "-" if none', 'cocktail-recipes');
    }
}
