<?php

namespace CocktailRecipes\Recipes\Values;

use CocktailRecipes\Recipes\Values\Units\Part;
use CocktailRecipes\Recipes\Values\Units\Unit;
use CocktailRecipes\Core\Helpers\Grammar;
use CocktailRecipes\Core\Helpers\HTML;

/**
 * @property int|float|array    $num
 * @property ?Unit              $unit
 */
class Measurement extends Quantity
{
    /** Optional Units */
    protected Unit $unit;

    /** @param int|float|array $num */
    protected function __construct($num, Unit $unit)
    {
        $this->num  = $num;
        $this->unit = $unit;
    }

    public function __toString(): string
    {
        return Grammar::numberWithWord($this->numToString(), $this->unitSuffix());
    }

    public function toHtml(): string
    {
        return Grammar::numberWithWord(
            $htmlNum = parent::toHtml(),
            HTML::esc($this->unitSuffix($htmlNum)),
            self::NNBSP
        );
    }

    protected function htmlNumber(float $num): string
    {
        return $this->unit->htmlNumber($num);
    }

    protected function unitSuffix(?string $htmlNum = null): string
    {
        return $this->unit->symbol
            ?? $this->unit->name($this->pluralCount($htmlNum));
    }

    public function adjustedCopy(?float $multiplier = null, ?Part $toUnit = null): self
    {
        $copy = parent::adjustedCopy($multiplier);
        if ($toUnit && $copy->unit instanceof Part) {
            [$copy->num, $copy->unit] = $toUnit->displayAs($copy->num);
        }
        return $copy;
    }
}
