<?php

namespace CocktailRecipes\Recipes\Helpers;

final class Modifiers
{
    private $modifiers = [];
    private $accessed  = [];

    public function add(string $modifier): void
    {
        $this->modifiers[$modifier] = true;
    }

    public function has(string $modifier): bool
    {
        $this->accessed[$modifier] = true;
        return isset($this->modifiers[$modifier]);
    }

    public function allowed(string ...$modifiers): void
    {
        foreach ($modifiers as $modifier) {
            $this->accessed[$modifier] = true;
        }
    }

    public function unused(): array
    {
        return array_diff_key($this->modifiers, $this->accessed);
    }

    public static function terms(): array
    {
        return [
            'alt' => __('alt,alternate', 'cocktail-recipes'),
            'opt' => __('opt,optional', 'cocktail-recipes'),
        ];
    }
}
