<?php

namespace CocktailRecipes\Recipes\Features;

/**
 * Adds support for the "opt" modifier for optional recipe elements
 *
 * This only adds the $optional property as well as the initialization of
 * it based on the the "[opt]" modifier being set. Any impact on rendering
 * when this is set must be handled at rendering time. You must also add
 * this to the class:
 *    protected const MODIFIERS = ['opt' => ['optional', true]];
 *
 * Used by Ingredient and Garnish classes.
 */
trait HasOptModifier
{
    /** Optional flag */
    protected bool $optional = false;

    /** Set $optional flag if opt modifer present */
    protected function init_optModifier(array $options): void
    {
        if ($options['optional'] ?? false) {
            $this->optional = true;
        }
    }

    /** Adjust $optional flag */
    public function setOptional(bool $optional): void
    {
        $this->optional = $optional;
    }
}
