<?php

namespace CocktailRecipes\Recipes\Features;

use CocktailRecipes\Recipes\Values\Measurement;
use CocktailRecipes\Core\Helpers\Grammar;

/**
 * Adds support for measurments
 *
 * Extends the HasQuantity trait to also allow a Measurement
 * to be set (i.e. quantity + unit)
 *
 * Used by Ingredient class.
 */
trait HasMeasurement
{
    use HasQuantity;

    public function __toString(): string
    {
        return $this->quantity
            ? ($this->quantity instanceof Measurement
                ?  Grammar::numberWithWord($this->quantity, $this->name())
                :  Grammar::numberWithWord($this->quantity, $this->name($this->qtyCount())))
            : $this->name();
    }

    public function toHtml(): string
    {
        return $this->quantity
            ? ($this->quantity instanceof Measurement
                ? Grammar::numberWithWord($this->quantity->toHtml(), $this->htmlName())
                : Grammar::numberWithWord(
                    $htmlNum = $this->quantity->toHtml(),
                    $this->htmlName($this->qtyCount($htmlNum))))
            : $this->htmlName();
    }

    protected function addSignatureSuffix(&$data): self
    {
        if ($this->quantity) {
            $data[] = $this->quantity->numToString();
            if ($this->quantity instanceof Measurement) {
                $data[] = substr(strrchr(get_class($this->quantity->unit), '\\'), 1);
            }
        }
        return $this;
    }
}
