<?php

namespace CocktailRecipes\Recipes\Elements\Methods;

/**
 * Thrown
 *
 * More aeration than stirring without vigorous mixing of shaking
 * Create tiny air bubbles which gives a lighter texture
 * Works well for drinks with vermouth or other wine-based components by enhancing aromatics
 */
class Thrown extends Method
{
    protected function init(array $options): void
    {
        $this->name    = _x('throw', 'cocktail method (name)', 'cocktail-recipes');
        $this->summary = _x('Thrown', 'cocktail method (summary)', 'cocktail-recipes');
        $this->steps   = [
            _x('Add ingredients to a mixing tin or glass without ice', 'cocktail method (step)', 'cocktail-recipes'),
            _x('Fill a second tin or glass with ice', 'cocktail method (step)', 'cocktail-recipes'),
            _x('From a height, pour the mixture from the first vessel into the one with ice in a smooth, steady stream to aerate and chill', 'cocktail method (step)', 'cocktail-recipes'),
            _x('Strain the liquid back into the first vessel, leaving the ice behind', 'cocktail method (step)', 'cocktail-recipes'),
            _x('Repeat a few times until properly mixed and chilled', 'cocktail method (step)', 'cocktail-recipes'),
            _x('Strain into {GLASS} {OVER_ICE}', 'cocktail method (step)', 'cocktail-recipes'),
        ];
    }

    public static function terms(): string
    {
        return __('throw,thrown', 'cocktail-recipes');
    }
}
