<?php

namespace CocktailRecipes\Recipes\Elements\Methods;

/**
 * Stirred
 *
 * Spirit-forward cocktails
 */
class Stirred extends Method
{
    protected function init(array $options): void
    {
        $this->name    = _x('stir', 'cocktail method (name)', 'cocktail-recipes');
        $this->summary = _x('Stirred', 'cocktail method (summary)', 'cocktail-recipes');
        $this->steps   = [
            _x('Add all ingredients to a mixing glass filled with ice', 'cocktail method (step)', 'cocktail-recipes'),
            _x('Stir until well chilled', 'cocktail method (step)', 'cocktail-recipes'),
            _x('Strain into {GLASS} {OVER_ICE}', 'cocktail method (step)', 'cocktail-recipes'),
        ];
    }

    public static function terms(): string
    {
        return __('stir,stirred', 'cocktail-recipes');
    }
}
