<?php

namespace CocktailRecipes\Recipes\Elements\Methods;

/**
 * Shaken
 *
 * Citrus, diary or egg-white cocktails
 */
class Shaken extends Method
{
    protected function init(array $options): void
    {
        $this->name    = _x('shake', 'cocktail method (name)', 'cocktail-recipes');
        $this->summary = _x('Shaken', 'cocktail method (summary)', 'cocktail-recipes');
        $this->steps   = [
            _x('Add all ingredients to a cocktail shaker and fill with ice', 'cocktail method (step)', 'cocktail-recipes'),
            _x('Shake ingredients to chill and mix', 'cocktail method (step)', 'cocktail-recipes'),
            _x('Strain into {GLASS} {OVER_ICE}', 'cocktail method (step)', 'cocktail-recipes'),
        ];
    }

    public static function terms(): string
    {
        return __('shake,shaken', 'cocktail-recipes');
    }
}
