<?php

namespace CocktailRecipes\Recipes\Elements\Methods;

/**
 * Rolled
 *
 * Gentle mixing and aeration without agitation
 * Used to combines thicker ingredients without creating foam or excessive aeration
 * Works well for Bloody Mary
 */
class Rolled extends Method
{
    protected function init(array $options): void
    {
        $this->name    = _x('roll', 'cocktail method (name)', 'cocktail-recipes');
        $this->summary = _x('Rolled', 'cocktail method (summary)', 'cocktail-recipes');
        $this->steps   = [
            _x('Add ingredients to a mixing tin or glass with ice', 'cocktail method (step)', 'cocktail-recipes'),
            _x('Pour the mixture, including ice, into another tin or glass in a smooth, steady motion', 'cocktail method (step)', 'cocktail-recipes'),
            _x('Repeat a few times, pouring back and forth to mix and chill without shaking', 'cocktail method (step)', 'cocktail-recipes'),
            _x('Strain into {GLASS} {OVER_ICE}', 'cocktail method (step)', 'cocktail-recipes'),
        ];
    }

    public static function terms(): string
    {
        return __('roll,rolled', 'cocktail-recipes');
    }
}
