<?php

namespace CocktailRecipes\Recipes\Elements\Methods;

use CocktailRecipes\Recipes\Elements\Element;

/**
 * Cocktail mixing method (e.g. stir, shake, build)
 *
 * Defines localized display text and recipe steps describing
 * how the drink is prepared.
 *
 * @property string     $name       read-only localized name
 * @property string     $summary    read-only localized summary text
 * @property string[]   $steps      read-only localized recipe steps
 */
abstract class Method extends Element
{
    /** Localized short title for use in cocktail summary (required) */
    protected string $summary;

    /**
     * @var string[]    localized steps for how to make cocktail (required)
     *
     * Placeholders:
     *   {GLASS}     $glass->a_name ?? $glass_name; e.g. `a coupe glass`
     *   {ICE}       $ice->singluar ? "a $ice->name" : $ice->name; e.g. 'a large cube' or 'crushed ice'
     *   {OVER_ICE}  $ice->over_ice; e.g. 'over a large ice cube'
     */
    protected array $steps;

    public static function keywords(): string
    {
        return __('method,technique', 'cocktail-recipes');
    }
}
