<?php

namespace CocktailRecipes\Recipes\Elements\Methods;

/**
 * Blended to slushy texture
 *
 * Typically for frozen citrus or fruit cocktails; i.e. ligher, icy texture
 * Examples: frozen daiquiri, frozen margarita, frozen negroni
 */
class BlendedSlushy extends Blended
{
    protected function init(array $options): void
    {
        $this->name    = _x('blend (slushy)', 'cocktail method (name)', 'cocktail-recipes');
        $this->summary = _x('Blend (slushy)', 'cocktail method (summary)', 'cocktail-recipes');
        $this->steps   = [
            _x('Add ingredients and ice to a blender; blend until slushy', 'cocktail method (step)', 'cocktail-recipes'),
            _x('Pour into {GLASS} {OVER_ICE}', 'cocktail method (step)', 'cocktail-recipes'),
        ];
    }

    public static function terms(): string
    {
        return __('blend slushy,blend until slushy,blended slushy,blended until slushy', 'cocktail-recipes');
    }
}
