<?php

namespace CocktailRecipes\Recipes\Elements\Methods;

/**
 * Blended briefly
 *
 * Textured, semi-crushed cocktails often using cracked or crushed ice
 * Examples: blended whiskey sour variant
 */
class BlendedBriefly extends Blended
{
    protected function init(array $options): void
    {
        $this->name    = _x('blend (briefly)', 'cocktail method (name)', 'cocktail-recipes');
        $this->summary = _x('Blend (briefly)', 'cocktail method (summary)', 'cocktail-recipes');
        $this->steps   = [
            _x('Add ingredients and ice to a blender; pulse briefly to combine', 'cocktail method (step)', 'cocktail-recipes'),
            _x('Pour into {GLASS} {OVER_ICE}', 'cocktail method (step)', 'cocktail-recipes'),
        ];
    }

    public static function terms(): string
    {
        return __('blend briefly,briefly blend,blended briefly,briefly blended', 'cocktail-recipes');
    }
}
