<?php

namespace CocktailRecipes\Recipes\Elements\Methods;

/**
 * Blended
 *
 * Creamy, uniform frozen drinks
 */
class Blended extends Method
{
    protected function init(array $options): void
    {
        $this->name    = _x('blend', 'cocktail method (name)', 'cocktail-recipes');
        $this->summary = _x('Blend', 'cocktail method (summary)', 'cocktail-recipes');
        $this->steps   = [
            _x('Add ingredients and ice to a blender; blend until smooth', 'cocktail method (step)', 'cocktail-recipes'),
            _x('Pour into {GLASS} {OVER_ICE}', 'cocktail method (step)', 'cocktail-recipes'),
        ];
    }

    public static function terms(): string
    {
        return __('blend,blend smooth,blend until smooth,blended,blended smooth,blended until smooth', 'cocktail-recipes');
    }
}
