<?php

namespace CocktailRecipes\Recipes\Elements\Ingredients;

use CocktailRecipes\Recipes\Contracts\AllowsCustomName;
use CocktailRecipes\Recipes\Contracts\AllowsMeasurement;
use CocktailRecipes\Recipes\Values\Units\Unit;
use CocktailRecipes\Recipes\Elements\Element;
use CocktailRecipes\Recipes\Features\HasCustomName;
use CocktailRecipes\Recipes\Features\HasMeasurement;
use CocktailRecipes\Recipes\Features\HasOptModifier;

/**
 * Ingredient
 *
 * @property string     $name       read-only localized name
 * @property ?Quantity  $quantity   read-only qty or qty+unit (Measurement)
 */
class Ingredient extends Element implements AllowsCustomName, AllowsMeasurement
{
    use HasCustomName, HasMeasurement, HasOptModifier;

    protected const MODIFIERS = [
        'opt' => ['optional', true]
    ];

    public static function keywords(): string
    {
        return __('ingredient,item', 'cocktail-recipes');
    }

    public function adjustedCopy(?float $multiplier = null, ?Unit $toUnit = null): self
    {
        $copy = clone $this;
        if ($this->quantity && ($multiplier || $toUnit)) {
            $copy->quantity = $this->quantity->adjustedCopy($multiplier, $toUnit);
        }
        return $copy;
    }
}
