<?php

namespace CocktailRecipes\Recipes\Elements\Ice;

/**
 * Pebble ice
 */
class Pebble extends Ice
{
    protected function init(array $options): void
    {
        $this->name     = _x('pebble ice', 'ice type', 'cocktail-recipes');
        $this->over_ice = _x('over pebble ice', 'serving phrase (for method steps)', 'cocktail-recipes');
        $this->summary  = _x('Pebble', 'ice type (summary)', 'cocktail-recipes');
        $this->alt      = ['Crushed'];
    }

    public static function shortTerms(): string
    {
        return __('nugget,pebble,pellet,sonic,tiki', 'cocktail-recipes');
    }

    public static function terms(): string
    {
        return __('nugget ice,pebble ice,pellet ice,sonic ice,tiki ice', 'cocktail-recipes');
    }

}
