<?php

namespace CocktailRecipes\Recipes\Elements\Ice;

/**
 * Large ice cube
 */
class LargeCube extends Ice
{
    protected function init(array $options): void
    {
        $this->name     = _x('large ice cube', 'ice type', 'cocktail-recipes');
        $this->over_ice = _x('over a large ice cube', 'serving phrase (for method steps)', 'cocktail-recipes');
        $this->summary  = _x('Large Cube', 'ice type (summary)', 'cocktail-recipes');
        $this->singular = true;
    }

    public static function shortTerms(): string
    {
        return __('cube', 'cocktail-recipes');
    }

    public static function terms(): string
    {
        return __('large cube,large ice cube,large rock,big cube,big ice cube,big rock', 'cocktail-recipes');
    }
}
