<?php

namespace CocktailRecipes\Recipes\Elements\Ice;

use CocktailRecipes\Recipes\Elements\Element;

/**
 * With ice
 *
 * @property string     $name       read-only localized name
 * @property ?string    $a_name     read-only localized name with article (for method steps)
 * @property ?string    $over_ice   read-only localized over ice type text (for method steps)
 * @property ?string    $summary    read-only localized summary text
 * @property ?string[]  $alt        read-only list of alternate ice types
 */
class Ice extends Element
{
    /** Localized serving phrase for method steps (e.g. over crushed ice) */
    protected ?string $over_ice = null;

    /** Localized short title for use in cocktail summary */
    protected ?string $summary = null;

    /** Alternate ice type(s) */
    protected ?array $alt = null;

    /** True if singular, e.g. a large ice cube */
    protected bool $singular = false;

    protected function init(array $options): void
    {
        $this->name     = _x('ice', 'ice type', 'cocktail-recipes');
        $this->over_ice = _x('over ice', 'serving phrase (for method steps)', 'cocktail-recipes');
        $this->summary  = _x('Yes', 'ice type (summary)', 'cocktail-recipes');
    }

    public static function keywords(): string
    {
        return __('ice', 'cocktail-recipes');
    }

    public static function shortTerms(): string
    {
        return __('cubes,cubed,rocks,yes', 'cocktail-recipes');
    }

    public static function terms(): string
    {
        return __('ice cubes,cubed ice,on the rocks,with ice', 'cocktail-recipes');
    }
}
