<?php

namespace CocktailRecipes\Recipes\Elements\Ice;

/**
 * Crushed ice
 */
class Crushed extends Ice
{
    protected function init(array $options): void
    {
        $this->name     = _x('crushed ice', 'ice type', 'cocktail-recipes');
        $this->over_ice = _x('over crushed ice', 'serving phrase (for method steps)', 'cocktail-recipes');
        $this->summary  = _x('Crushed', 'ice type (summary)', 'cocktail-recipes');
    }

    public static function shortTerms(): string
    {
        return __('cracked,crushed', 'cocktail-recipes');
    }

    public static function terms(): string
    {
        return __('cracked ice,crushed ice', 'cocktail-recipes');
    }
}
