<?php

namespace CocktailRecipes\Recipes\Elements\Glassware;

/**
 * Tea cup
 */
class TeaCup extends Glass
{
    protected function init(array $options): void
    {
        $this->name    = _x('tea cup', 'glassware name', 'cocktail-recipes');
        $this->a_name  = _x('a tea cup', 'glassware name with article (for method steps)', 'cocktail-recipes');
        $this->summary = _x('Tea Cup', 'glassware (summary)', 'cocktail-recipes');
        $this->alt     = ['CoffeeMug', 'IrishCoffee'];
    }

    public static function shortTerms(): string
    {
        return __('tea', 'cocktail-recipes');
    }

    public static function terms(): string
    {
        return __('tea cup,tea mug', 'cocktail-recipes');
    }
}
