<?php

namespace CocktailRecipes\Recipes\Elements\Glassware;

/**
 * Shooter glass
 *
 * Taller and slightly larger than shot glass
 */
class Shooter extends Glass
{
    protected function init(array $options): void
    {
        $this->name    = _x('shooter glass', 'glassware name', 'cocktail-recipes');
        $this->a_name  = _x('a shooter glass', 'glassware name with article (for method steps)', 'cocktail-recipes');
        $this->summary = _x('Shooter', 'glassware (summary)', 'cocktail-recipes');
        $this->alt     = ['Cordial', 'Shot'];
    }

    public static function shortTerms(): string
    {
        return __('shooter', 'cocktail-recipes');
    }

    public static function terms(): string
    {
        return __('shooter glass', 'cocktail-recipes');
    }
}
