<?php

namespace CocktailRecipes\Recipes\Elements\Glassware;

/**
 * Rocks glass
 *
 * Also known as old fashioned glass
 */
class Rocks extends Glass
{
    protected function init(array $options): void
    {
        $this->name    = _x('rocks glass', 'glassware name', 'cocktail-recipes');
        $this->a_name  = _x('a rocks glass', 'glassware name with article (for method steps)', 'cocktail-recipes');
        $this->summary = _x('Rocks', 'glassware (summary)', 'cocktail-recipes');
    }

    public static function shortTerms(): string
    {
        return __('lowball,old fashioned,rocks,whiskey,whisky', 'cocktail-recipes');
    }

    public static function terms(): string
    {
        return __('lowball glass,old fashioned glass,rocks glass,rocks tumbler,tumbler,tumbler glass,whiskey glass,whiskey tumbler,whisky glass,whisky tumbler', 'cocktail-recipes');
    }
}

