<?php

namespace CocktailRecipes\Recipes\Elements\Glassware;

/**
 * Port wine glass
 */
class Port extends Glass
{
    protected function init(array $options): void
    {
        $this->name    = _x('port glass', 'glassware name', 'cocktail-recipes');
        $this->a_name  = _x('a port glass', 'glassware name with article (for method steps)', 'cocktail-recipes');
        $this->summary = _x('Port', 'glassware (summary)', 'cocktail-recipes');
        $this->alt     = ['Wine'];
    }

    public static function shortTerms(): string
    {
        return __('port', 'cocktail-recipes');
    }

    public static function terms(): string
    {
        return __('port glass,port wine glass', 'cocktail-recipes');
    }
}
