<?php

namespace CocktailRecipes\Recipes\Elements\Glassware;

/**
 * Martini glass (aka cocktail glass)
 */
class Martini extends Glass
{
    protected function init(array $options): void
    {
        $this->name    = _x('martini glass', 'glassware name', 'cocktail-recipes');
        $this->a_name  = _x('a martini glass', 'glassware name with article (for method steps)', 'cocktail-recipes');
        $this->summary = _x('Martini', 'glassware (summary)', 'cocktail-recipes');
        $this->alt     = ['Coupe', 'NickNora'];
    }

    public static function shortTerms(): string
    {
        return __('cocktail,martini', 'cocktail-recipes');
    }

    public static function terms(): string
    {
        return __('cocktail_glass,martini coupe,martini glass', 'cocktail-recipes');
    }
}
