<?php

namespace CocktailRecipes\Recipes\Elements\Glassware;

/**
 * Metal Julep cup
 */
class JulepCup extends Glass
{
    protected function init(array $options): void
    {
        $this->name    = _x('julep cup', 'glassware name', 'cocktail-recipes');
        $this->a_name  = _x('a julep cup', 'glassware name with article (for method steps)', 'cocktail-recipes');
        $this->summary = _x('Julep Cup', 'glassware (summary)', 'cocktail-recipes');
        $this->alt     = ['CopperMug'];
    }

    public static function shortTerms(): string
    {
        return __('julep,metal', 'cocktail-recipes');
    }

    public static function terms(): string
    {
        return __('julep cup,metal cup,mint julep cup', 'cocktail-recipes');
    }
}
