<?php

namespace CocktailRecipes\Recipes\Elements\Glassware;

/**
 * Irish coffee glass
 */
class IrishCoffee extends Glass
{
    protected function init(array $options): void
    {
        $this->name    = _x('Irish coffee glass', 'glassware name', 'cocktail-recipes');
        $this->a_name  = _x('an Irish coffee glass', 'glassware name with article (for method steps)', 'cocktail-recipes');
        $this->summary = _x('Irish Coffee', 'glassware (summary)', 'cocktail-recipes');
        $this->alt     = ['CoffeeMug'];
    }

    public static function shortTerms(): string
    {
        return __('hot toddy,irish coffee,toddy', 'cocktail-recipes');
    }

    public static function terms(): string
    {
        return __('glass coffee cup,glass coffee mug,glass mug,hot toddy glass,hot toddy mug,irish coffee cup,irish coffee glass,irish coffee mug,toddy glass,toddy mug', 'cocktail-recipes');
    }

}
