<?php

namespace CocktailRecipes\Recipes\Elements\Glassware;

/**
 * Highball glass
 *
 * Also known as collins or fizz glass
 */
class Highball extends Glass
{
    protected function init(array $options): void
    {
        $this->name    = _x('highball glass', 'glassware name', 'cocktail-recipes');
        $this->a_name  = _x('a highball glass', 'glassware name with article (for method steps)', 'cocktail-recipes');
        $this->summary = _x('Highball', 'glassware (summary)', 'cocktail-recipes');
    }

    public static function shortTerms(): string
    {
        return __('collins,fizz,highball', 'cocktail-recipes');
    }

    public static function terms(): string
    {
        return __('collins glass,fizz glass,highball glass', 'cocktail-recipes');
    }
}
