<?php

namespace CocktailRecipes\Recipes\Elements\Glassware;

use CocktailRecipes\Recipes\Elements\Element;

/**
 * Glassware types
 *
 * @property string     $name       read-only localized name
 * @property ?string    $a_name     read-only localized name with article (for method steps)
 * @property ?string    $summary    read-only localized summary text
 * @property ?string[]  $alt        read-only list of alternate glass types
 */
abstract class Glass extends Element
{
    /** Localized name with article for use in method steps (e.g. a rocks glass) */
    protected ?string $a_name = null;

    /** Localized short title for use in cocktail summary */
    protected ?string $summary = null;

    /** Alternate glassware type(s) */
    protected ?array $alt = null;

    public static function keywords(): string
    {
        return __('glass,glassware', 'cocktail-recipes');
    }
}
