<?php

namespace CocktailRecipes\Recipes\Elements\Glassware;

/**
 * Champagne flute
 */
class Flute extends Glass
{
    protected function init(array $options): void
    {
        $this->name    = _x('champagne flute', 'glassware name', 'cocktail-recipes');
        $this->a_name  = _x('a champagne flute', 'glassware name with article (for method steps)', 'cocktail-recipes');
        $this->summary = _x('Flute', 'glassware (summary)', 'cocktail-recipes');
        $this->alt     = ['Coupe'];
    }

    public static function shortTerms(): string
    {
        return __('champagne,flute', 'cocktail-recipes');
    }

    public static function terms(): string
    {
        return __('champagne flute,champagne glass,flute glass', 'cocktail-recipes');
    }
}
