<?php

namespace CocktailRecipes\Recipes\Elements\Glassware;

/**
 * Coupette glass
 *
 * Slightly larger than coupe glass
 */
class Coupette extends Glass
{
    protected function init(array $options): void
    {
        $this->name    = _x('coupette glass', 'glassware name', 'cocktail-recipes');
        $this->a_name  = _x('a coupette glass', 'glassware name with article (for method steps)', 'cocktail-recipes');
        $this->summary = _x('Coupette', 'glassware (summary)', 'cocktail-recipes');
        $this->alt     = ['Coupe', 'Martini'];
    }

    public static function shortTerms(): string
    {
        return __('coupette', 'cocktail-recipes');
    }

    public static function terms(): string
    {
        return __('coupette glass', 'cocktail-recipes');
    }
}
