<?php

namespace CocktailRecipes\Recipes\Elements\Glassware;

/**
 * Cordial glass
 */
class Cordial extends Glass
{
    protected function init(array $options): void
    {
        $this->name    = _x('cordial glass', 'glassware name', 'cocktail-recipes');
        $this->a_name  = _x('a cordial glass', 'glassware name with article (for method steps)', 'cocktail-recipes');
        $this->summary = _x('Cordial', 'glassware (summary)', 'cocktail-recipes');
        $this->alt     = ['Shooter', 'Shot'];
    }

    public static function shortTerms(): string
    {
        // We could make a pony glass its own glassware type, as it is
        // technically a little smaller, typically 1 oz vs 1.5 oz.
        return __('cordial,pony', 'cocktail-recipes');
    }

    public static function terms(): string
    {
        return __('cordial glass,pony glass', 'cocktail-recipes');
    }
}
