<?php

namespace CocktailRecipes\Recipes\Elements\Garnishes;

use CocktailRecipes\Recipes\Contracts\AllowsCustomName;
use CocktailRecipes\Recipes\Contracts\AllowsQuantity;
use CocktailRecipes\Recipes\Elements\Element;
use CocktailRecipes\Recipes\Features\HasCustomName;
use CocktailRecipes\Recipes\Features\HasQuantity;
use CocktailRecipes\Recipes\Features\HasOptModifier;

/**
 * Garnish
 *
 * @property string     $name       read-only localized name
 * @property ?Quantity  $quantity   read-only quantity object
 */
class Garnish extends Element implements AllowsCustomName, AllowsQuantity
{
    use HasCustomName, HasQuantity, HasOptModifier;

    protected const MODIFIERS = [
        'opt' => ['optional', true]
    ];

    public static function keywords(): string
    {
        return __('garnish', 'cocktail-recipes');
    }
}
