<?php

namespace CocktailRecipes\Jobs;

use CocktailRecipes\Recipes\Helpers\TokenMap;
use CocktailRecipes\Shortcodes\CocktailShortcode as Shortcode;
use CocktailRecipes\Core\Base\Job;
use CocktailRecipes\Core\Helpers\Cache;
use CocktailRecipes\Core\Helpers\Logger;

class Daily extends Job
{
    public function handle(): bool
    {
        if (Cache::enabled()) {

            // rebuild token map if missing
            if (!TokenMap::cached() && TokenMap::rebuild(false)) {
                Logger::info('Token map rebuilt during daily maintenance');
            }

            // cleanup old token map cache entries
            TokenMap::cleanup();

            // cleanup old cache entries
            // @todo make caching period configurable
            $age = 7 * DAY_IN_SECONDS;
            Cache::clearOld($age, Shortcode::RECIPE_CACHE_PREFIX);
            Cache::clearOld($age, Shortcode::UNIT_BTN_CACHE_NAME . '-');
        }
        return true;
    }
}
