<?php

namespace CocktailRecipes\Core\i18n;

/**
 * Norwegian (Bokmål) language locale handler
 */
class no extends Handler
{
    protected array $fullDurations    = ['dag', 'time', 'minutt', 'sekund'];
    protected array $shortDurations   = ['dag', 't', 'min', 's'];
    protected bool  $pluralizeShortDurations = false;

    /**
     * Pluralize regular Norwegian nouns
     *
     * Covers roughly 90–95% of regular nouns:
     * - Adds 'er' to most nouns (e.g. bil -> biler)
     * - Adds 'r' to nouns ending in 'e' (e.g. jente -> jenter)
     * - Words ending in 'el', 'er' or 'en' unchanged
     * Does not handle irregulars or dialectal variants.
     */
    public function pluralize(string $text, int $count = 1): string
    {
        if (abs($count) == 1) return $text;
        if (preg_match('/e$/iu', $text)) return $text . 'r';
        if (preg_match('/(el|er|en)$/iu', $text)) return $text;
        return $text . 'er';
    }

    /**
     * Add an indefinite article to a noun
     *
     * Uses 'en' as the masculine default. Does not account for gender (en/ei/et)
     * or plural forms. Avoids adding a second article if one already exists.
     */
    public function indefinite(string $text): string
    {
        if (preg_match('/^(en|ei|et)(\s|$)/iu', $text)) return $text;
        return "en $text";
    }
}
