<?php

namespace CocktailRecipes\Core\i18n;

/**
 * Dutch language locale handler
 */
class nl extends Handler
{
    protected array $fullDurations    = ['dag', 'uur', 'minuut', 'seconde'];
    protected array $shortDurations   = ['dag', 'u', 'min', 's'];
    protected bool  $pluralizeShortDurations = false;

    /**
     * Pluralize regular Dutch nouns
     *
     * Covers roughly 90–95% of regular nouns:
     * - Adds 'en' to most words (e.g. dag -> dagen, stoel -> stoelen)
     * - Adds "'s" to words ending in vowels or unstressed syllables (e.g. auto -> auto's)
     * - Leaves most words ending in -s, -x, or -f unchanged
     * Handles nearly all standard cases; irregular stem changes such as 'f' -> 'v',
     * or 's' -> 'z' not included.
     */
    public function pluralize(string $text, int $count = 1): string
    {
        if (abs($count) == 1) return $text;
        if (preg_match('/[aeiou]$/iu', $text)) return $text . "'s";
        if (preg_match('/[sx]$/iu', $text)) return $text;
        return $text . 'en';
    }

    /**
     * Add an indefinite article to a noun
     *
     * Uses 'een' as a gender-neutral default. Does not account for gender
     * (de/het nouns) or plural nouns. Avoids adding a second article if one
     * already exists.
     */
    public function indefinite(string $text): string
    {
        if (preg_match('/^(een)(\s|$)/iu', $text)) return $text;
        return "een $text";
    }
}
