<?php

namespace CocktailRecipes\Core\Renderers;

use CocktailRecipes\Core\Helpers\HTML;

class Text extends Renderer
{
    protected string $text;

    public function __construct(string $text)
    {
        $this->text = $text;
    }

    public function __toString(): string
    {
        return $this->text;
    }

    public function toHtml(): string
    {
        return HTML::esc($this->text);
    }
}
