<?php

namespace CocktailRecipes\Core\Renderers;

use CocktailRecipes\Core\Contracts\Renderable;

class Join extends Renderer
{
    protected array $items;
    protected $formatter = null;

    /**
     * Constructor
     *
     * @param array<Renderable> $items      array of renderable objects
     */
    public function __construct(Renderable ...$items)
    {
        $this->items = $items;
    }

    /**
     * Set a formatter function to apply to each item
     *
     * @param callable  $formatter  fn(name, obj) => formatteddName
     */
    public function with(callable $formatter): self
    {
        $this->formatter = $formatter;
        return $this;
    }

    protected function join(array $items): string
    {
        return implode(', ', $items);
    }

    public function __toString(): string
    {
        return $this->join(array_map(
            fn($item) => $this->formatter
                ? ($this->formatter)((string) $item, $item)
                : (string) $item,
            $this->items
        ));
    }

    public function toHtml(): string
    {
        return $this->join(array_map(
            fn($item) => $this->formatter
                ? ($this->formatter)($item->toHtml(), $item)
                : $item->toHtml(),
            $this->items
        ));
    }
}
