<?php

namespace CocktailRecipes\Core\Renderers;

use CocktailRecipes\Core\Contracts\Renderable;

class Format extends Renderer
{
    protected string $format;
    protected array $args;

    /**
     * Constructor
     *
     * @param string        $format     sprintf format string
     * @param Renderable    ...$args    renderable format arguments
     */
    public function __construct(string $format, Renderable ...$args)
    {
        $this->format = $format;
        $this->args = $args;
    }

    protected function insert(array $items): string
    {
        return sprintf($this->format, ...$items);
    }

    public function __toString(): string
    {
        return $this->insert(array_map(
            fn($item) => (string) $item,
            $this->args
        ));
    }

    public function toHtml(): string
    {
        return $this->insert(array_map(
            fn($item) => $item->toHtml(),
            $this->args
        ));
    }
}
