<?php

namespace CocktailRecipes\Core\Iterators;

use DirectoryIterator;
use FilterIterator;

/** Iterator for all PHP files in directory except index.php */
class PhpFileIterator extends FilterIterator
{
    public function __construct(string $path)
    {
        parent::__construct(new DirectoryIterator(rtrim($path, '/') . '/'));
    }

    public function accept(): bool
    {
        /** @var \SplFileInfo $file */
        $file = parent::current();
        return $file->isFile()
            && $file->getExtension() == 'php'
            && $file->getBasename('.php') != 'index';
    }

    /** Return just the basename without .php extension */
    public function current(): string
    {
        return parent::current()->getBasename('.php');
    }
}
