<?php

namespace CocktailRecipes\Core\Helpers;

final class User
{
    /** True if user is logged in */
    public static function isLoggedIn(): bool
    {
        return is_user_logged_in();
    }

    /** True if user is an administrator */
    public static function isAdmin(): bool
    {
        return is_user_logged_in()
            && current_user_can('manage_options');
    }

    /** True if user an administrator is viewing a page */
    public static function isAdminViewer(): bool
    {
        return !is_admin()
            && self::isAdmin();
    }

    /** True if user is an editor or higher */
    public static function isEditor(): bool
    {
        return is_user_logged_in()
            && current_user_can('edit_others_posts');
    }

    /** True if user is a contributor or higher */
    public static function isContributor(): bool
    {
        return is_user_logged_in()
            && current_user_can('edit_posts');
    }

    /** True if user can edit the current post */
    public static function canEditPage(): bool
    {
        return is_singular()
            && is_user_logged_in()
            && current_user_can('edit_post', get_the_ID());
    }

    /** True if user is super user on a multisite install */
    public static function isSuperAdmin(): bool
    {
        return is_multisite()
            && is_user_logged_in()
            && is_super_admin();
    }
}
