<?php

namespace CocktailRecipes\Core\Helpers;

use CocktailRecipes\Plugin;

final class Output
{
    /** Render an HTML template with insertion data */
    public static function render(string $name, array $data = []): string
    {
        // prevent path traversal or exploits
        if (!preg_match('/^[a-z0-9-]+(?:\/[a-z0-9-]+)*$/i', $name)) return '';
        // support custom theme overrides
        $file = get_stylesheet_directory() . '/' . Plugin::slug() . '/' . $name . '.php';
        if (!File::isFile($file)) {
            $file = Plugin::path() . 'templates/' . $name . '.php';
        }
        // expose data elements and render
        extract($data, EXTR_SKIP);
        ob_start();
        include $file;
        $html = ob_get_clean();
        return apply_filters('cocktail_recipes_rendered', $html, $name, $data);
    }

    /** Render an HTML partial template */
    public static function partial(string $name, array $data = []): string
    {
        return self::render('partials/' . $name, $data);
    }

    /** Return true for the first call of a specific named reference */
    public static function onlyOnce(string $name): bool
    {
        static $keys = [];
        if ($keys[$name] ?? null) return false;
        return $keys[$name] = true;
    }
}
