<?php

namespace CocktailRecipes\Core\Helpers;

/**
 * Caching with current language as suffix
 */
class LangCache extends Cache
{
    private static $nameSuffix = null;
    private static $nameSuffixLen;

    private static function setNameSuffix(): void
    {
        self::$nameSuffix = '-' . (Locale::code() ?: 'default');
        self::$nameSuffixLen = strlen(self::$nameSuffix);
    }

    protected static function cacheFile(string $name): string
    {
        if (self::$nameSuffix === null) self::setNameSuffix();
        self::checkName($name);
        return self::path() . $name . self::$nameSuffix . '.php';
    }

    protected static function eachMatch(string $name): bool
    {
        if (self::$nameSuffix === null) self::setNameSuffix();
        return substr($name, -self::$nameSuffixLen) === self::$nameSuffix;
    }
}
