<?php

namespace CocktailRecipes\Core\Base;

use LogicException;

/**
 * Read-only properties
 *
 * Exposes protected properties as public readonly. Any properties
 * starting with '_' are treated as internal and not exposed.
 */
abstract class ReadOnlyProps
{
    public function __get(string $name)
    {
        if ($name == '' || $name[0] == '_') return null;
        return $this->$name ?? null;
    }

    public function __isset(string $name): bool
    {
        return $name != '' && $name[0] != '_' && isset($this->$name);
    }

    final public function __set(string $name, $_): void
    {
        throw new LogicException('Cannot set read-only property ' . static::class . '::' . esc_html($name));
    }

    final public function __unset(string $name): void
    {
        throw new LogicException('Cannot unset read-only property ' . static::class . '::' . esc_html($name));
    }
}
